#include "stdafx.h"
#include "XMLFile.h"

#include "rapidxml_print.hpp"

#include <iostream>
#include <ostream>
#include <fstream>
#include <sstream>

//
// XML file full path MINUS the extension
//
XMLFile::XMLFile(const char *_filePath) 
{
	filePath = _filePath;
	filePath += ".xml";

	node = NULL;
}

XMLFile::~XMLFile() 
{

}

void XMLFile::AppendChild(const char *childName)
{
	_Node *temp = doc.allocate_node(
		node_element, 
		xml_string(childName));

	if(!node) {
		doc.append_node(temp);
	} else {
		node->append_node(temp);
	}

	node = temp;
}

bool XMLFile::AppendAttribute(const char *name, const char *value)
{
	if(!node) {
		return false;
	}

	_Att *att = doc.allocate_attribute(
		xml_string(name),
		xml_string(value));

	node->append_attribute(att);
	return true;
}

bool XMLFile::SetNodeValue(const char *value) 
{
	if(!node) {
		return false;
	}

	node->value(xml_string(value));
	return true;
}

void XMLFile::SelectFirstChild()
{
	if(!node) {
		node = doc.first_node();
	} else {
		node = node->first_node();
	}
}

void XMLFile::SelectLastChild()
{
	if(!node) {
		node = doc.last_node();
	} else {
		node = node->last_node();
	}
}

void XMLFile::SelectParent()
{
	if(!node) {
		node = doc.first_node();
	}

	node = node->parent();
}

void XMLFile::SelectRoot()
{
	if(doc.first_node()) {
		node = doc.first_node();
	} else {
		node = NULL;
	}
}

void XMLFile::Print() 
{
	std::ofstream fileStream(filePath.c_str());
	if(!fileStream.is_open()) {
		return;
	}

	fileStream 
		<< "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>"
		<< std::endl
		<< doc;

	fileStream.close();
}